from random import randrange
from point import Point
from path import Path
import math
from os import system

class Solve:
  def __init__(self, settings, points):
    self.settings = settings
    self.best_cost = None
    self.paths = []
    self.points = points
    self.length = len(points)
    self.crs = int(round(self.settings.crs*self.length))
    self.mut = int(round(self.settings.mut*self.length)/2)
    
  def initPath (self):
    for i in range(self.settings.perm_n):
      path_def = range(self.length)
      p=[]
      l = self.length
      while l>0:
	p.append ( path_def.pop( randrange(0, l) ) )
	l-=1
      self.paths.append(Path(p, self.points))
      
    self.paths.sort()
    print self.paths
    self.best_cost = self.paths[0].cost


  def again (self):
    """generate next permutations
    NOTE: for performance reason, best current answer always passed to next permutations"""
    
    i=0
    while i < self.settings.perm_n-1:
      (a,b) = twoRandoms(0, self.settings.perm_n)
      #print (a,b), "crossover, selected", self.paths[a].path, self.paths[b].path
      self.paths.insert(1, Path( self.nextPermutation(a,b), self.points ) )
      i+=1
    del i
    
    del self.paths[self.settings.perm_n:]
    
    self.paths.sort()
    self.best_cost = self.paths[0].cost
    print self.paths
  
  
  def solve(self):
    self.initPath()
  
  
  def nextPermutation (self, x, y):
    """x and y are parent paths index. permutation selection is one point crossover
       this apply crossover selection and mutation changes"""
    result = self.paths[x].path[:self.crs]
    result.extend([ a for a in self.paths[y].path if a not in result ])
    #print result, "from", self.paths[x].path, "and", self.paths[y].path
    i = 0
    while i < self.mut:
      (a,b) = twoRandoms(0, self.length)
      #print (a,b), "mutation"
      #result.insert(a, result.pop(b))
      i+=1
    del i
    #print "after mutation", result
    return result
    
    
def twoRandoms (a, b):
    m = randrange(1, b)
    return (randrange(a, m), randrange(m, b))
