from point import Point

class Path:
  def __init__(self, path, points):
    self.points = points
    self.path = path
    self.edgesCost = []
    self.cost = self.cost(path)

  def cost (self, path):
    cost = sum ( map (lambda x: Point.distance(self.points[path[x]], self.points[path[x-1]]), xrange(1,len(path)) ) )
    return cost + Point.distance(self.points[path[0]], self.points[path[-1]] )
    #cost = 0
    #for x in xrange(1,len(path)):
        #d = Point.distance(self.points[path[x]], self.points[path[x-1]])
        #self.edgesCost.append(int(d))
        #cost += d

    #d = Point.distance(self.points[path[0]], self.points[path[-1]])
    #self.edgesCost.append(int(d))
    #cost += d
    #return cost

  def __str__(self):
    return "{0} with {1:.2f} cost".format(self.path, self.cost )
    
    
  def __repr__(self):
    return "< {0}:{1:.2f} >".format(self.path, self.cost)
  
  
  def __cmp__(self, b):
    if self.cost < b.cost:
      return -1
    elif self.cost == b.cost:
      return 0
    else:
      return 1