from PyQt4 import QtCore, QtGui
from point import Point

class PaintBoardView (QtGui.QGraphicsView):
  def __init__(self, parent=0):
    super(PaintBoardView, self).__init__(parent)
    self.s = self.scene
    
  
class PaintBoardScene (QtGui.QGraphicsScene):
  def __init__(self, parent=0):
    super(PaintBoardScene, self).__init__(parent)
    self.points = []
    self.qpoints = []
    self.pointCount = 0
    
    
  def mousePressEvent (self, event):
    pos = event.lastScenePos()
    self.qpoints.append(pos)
    self.addEllipse(QtCore.QRectF(pos.x()-5, pos.y()-5, 10, 10))
    self.addText( "%d" % self.pointCount ).setPos( pos.x(), pos.y() )
    self.pointCount += 1
    self.points.append(Point(pos.x(), pos.y()))
    
  def showPath(self, path):
    map ( lambda x: self.addLine(QtCore.QLineF(self.qpoints[path[x]], self.qpoints[path[x-1]])), xrange(1, self.pointCount) )
    if self.pointCount > 2:
        self.addLine( QtCore.QLineF( self.qpoints[path[0]], self.qpoints[path[-1]] ) )
    self.update()
    
  def clearPath(self):
    map (self.removeItem, [ i for i in self.items() if i.type() is 6 ] )
