from main_windowUi import *
from PyQt4 import QtCore, QtGui
from paintboard import *
from solve import Solve
from settings import Settings
from os import system
import sys

class Ui(Ui_main):
  def __init__(self):
    self.dialog = QtGui.QDialog()
    self.setupUi(self.dialog)
    self.setup()

    QtCore.QObject.connect(self.solveButton, QtCore.SIGNAL("clicked()"), self.solve)
    QtCore.QObject.connect(self.clearButton, QtCore.SIGNAL("clicked()"), self.pbs.clearPath)
  
  def setup(self):
    self.progressBar.hide()
    self.pbv = PaintBoardView(self.dialog)
    self.pbs = PaintBoardScene(self.dialog)
    self.pbv.setScene(self.pbs)
    self.pbv.setGeometry(QtCore.QRect(10, 10, 380, 300))
    self.pbv.show()
    
    
  def solve(self):
    self.progressBar.show()
    s=Settings(self.mut.value(), self.crs.value(), self.perm.value(), self.loop.value())
    solve=Solve(s, self.pbs.points)
    solve.solve()
    for i in range (self.loop.value()):
      self.progressBar.setValue( i * 100 / self.loop.value());
      solve.again()
      
    self.pbs.showPath(solve.paths[0].path)
    self.best_cost.setText("{0:.2f}".format(solve.best_cost))
    self.progressBar.hide()
      
    
  def show(self):
    self.dialog.show()
